<?php
/* --------------------------------------------------------------
   CommandHandlerProvider.php 2020-04-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Command;

use Psr\Container\ContainerInterface;

/**
 * Class CommandHandlerProvider
 *
 * @package Gambio\Core\Command
 */
class CommandHandlerProvider implements Interfaces\CommandHandlerProvider
{
    /**
     * @var ContainerInterface
     */
    private $container;
    
    /**
     * @var string[][]
     */
    private $handlers = [];
    
    
    /**
     * CommandHandlerProvider constructor.
     *
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }
    
    
    /**
     * @inheritDoc
     */
    public function attachHandler(string $commandClass, string $handler): void
    {
        if (!array_key_exists($commandClass, $this->handlers)) {
            $this->handlers[$commandClass] = [];
        }
        
        $this->handlers[$commandClass][] = $handler;
        $this->handlers[$commandClass]   = array_unique($this->handlers[$commandClass], SORT_REGULAR);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getHandlerForCommand(object $command): iterable
    {
        $commandClass = get_class($command);
        $array        = $this->handlers[$commandClass] ?? [];
        
        return array_map(function ($handler) {
            return $this->container->get($handler);
        },
            $array);
    }
}